using System;
using System.Collections.Generic;

namespace Zlatnici3
{
    class Program
    {
        struct Portal
        {
            public int banka1;
            public int banka2;
        }

        static int NadjiNajoptimalnijuBanku(int[] novacUBankama, Portal[] portali)
        {
            int najboljaBanka = 0;
            int minKristala = int.MaxValue;
            for (int i = 0; i < novacUBankama.Length; i++)
            {
                int potrebnihKristala = TestirajOptimalnostBanke(i + 1, novacUBankama, portali);
                if (minKristala > potrebnihKristala)
                {
                    minKristala = potrebnihKristala;
                    najboljaBanka = i + 1;
                }
            }
            return najboljaBanka;
        }

        static int TestirajOptimalnostBanke(int indexBanke, int[] novacUBankama, Portal[] portali)
        {
            Stack<int> grafBanki = new Stack<int>();
            int trenutniIndex = indexBanke;
            List<int> prodjeneBanke = new List<int>();
            int potrosenihKristala = 0;

            while(prodjeneBanke.Count < novacUBankama.Length)
            {
                if (!grafBanki.Contains(trenutniIndex))
                {
                    grafBanki.Push(trenutniIndex);
                }
                int sledecaBanka = SledecaBanka(trenutniIndex, prodjeneBanke, portali, grafBanki);

                if (sledecaBanka != -1)
                {
                    trenutniIndex = sledecaBanka;
                }
                else
                {
                    prodjeneBanke.Add(trenutniIndex);
                    potrosenihKristala += novacUBankama[trenutniIndex - 1] * (grafBanki.Count - 1);
                    grafBanki.Pop();
                    if (grafBanki.Count != 0)
                    {
                        trenutniIndex = grafBanki.Peek();
                    }
                }
            }
            return potrosenihKristala;
        }

        static int SledecaBanka(int trenutniIndex, List<int> prodjeneBanke, Portal[] portali, Stack<int> grafBanki)
        {
            for (int i = 0; i < portali.Length; i++)
            {
                if (portali[i].banka1 == trenutniIndex)
                {
                    if (!prodjeneBanke.Contains(portali[i].banka2) && !grafBanki.Contains(portali[i].banka2))
                    {
                        return portali[i].banka2;
                    }
                }
                if (portali[i].banka2 == trenutniIndex)
                {
                    if (!prodjeneBanke.Contains(portali[i].banka1) && !grafBanki.Contains(portali[i].banka1))
                    {
                        return portali[i].banka1;
                    }
                }
            }
            return -1;
        }



        static void Main(string[] args)
        {
            int n = int.Parse(Console.ReadLine());
            Portal[] portali = new Portal[n - 1];

            string[] input;
            for(int i = 0; i < n - 1; i++)
            {
                input = Console.ReadLine().Split();
                portali[i].banka1 = int.Parse(input[0]);
                portali[i].banka2 = int.Parse(input[1]);
            }

            input = Console.ReadLine().Split();
            int[] novacUBankama = new int[n];

            for(int i = 0; i < n; i++)
            {
                novacUBankama[i] = int.Parse(input[i]);
            }

            int q = int.Parse(Console.ReadLine());
            int[] resenja = new int[q + 1];
            resenja[0] = NadjiNajoptimalnijuBanku(novacUBankama, portali);
            for (int i = 1; i <= q; i++)
            {
                input = Console.ReadLine().Split();
                novacUBankama[int.Parse(input[1]) - 1] += int.Parse(input[0]);
                resenja[i] = NadjiNajoptimalnijuBanku(novacUBankama, portali);
            }

            for (int i = 0; i < q + 1; i++)
            {
                Console.WriteLine(resenja[i]);
            }
        }
    }
}